SELECT
    strftime('%m/%d/%Y', c.date) AS date
    , CASE WHEN c.amount < 0 THEN '<span class="neg">' ELSE '<span class="pos">' END + CAST(c.amount AS text) + '</span>' AS amount
    , c.account
    , c.item
    , c.company
    , c.comment
FROM
    cashbook c
ORDER BY
    c.date
    , c.id
